import useSWR from "swr";
import { revalidateBuildStatusCheckMap } from "@/features/feeds/server/api.statuses";
import { SWR_OPTIONS_WITH_REVALIDATE_INTERVAL } from "@/config/swr";
import { AppValidationError, AppValidationStatusOption } from "@/zod/feeds.schema";

export type INTERNAL__MappedValues = Awaited<ReturnType<typeof revalidateBuildStatusCheckMap>>
export type INTERNAL__BuildStatusMapToGlobalStatusReturn = {
  status: AppValidationStatusOption,
  error?: {
    message: AppValidationError,
    agency: string,
  },
  metadata: {
    groupings: INTERNAL__MappedValues
  }
}

export function useBuildStatusRevalidateCheckMap() {
  return useSWR(
    ["BUILD_STATUS_REVALIDATION_CHECK_MAP"],
    revalidateBuildStatusCheckMap,
    SWR_OPTIONS_WITH_REVALIDATE_INTERVAL,
  )
}

export function buildStatusMapToGlobalStatus(groupedAgencies: undefined | INTERNAL__MappedValues): INTERNAL__BuildStatusMapToGlobalStatusReturn | undefined {
  if (!groupedAgencies) {
    return;
  }

  const status = INTERNAL__getStatusFromAgenciesRecord(groupedAgencies)

  const firstErrorAgency = groupedAgencies["FAILED"][0]
  if (!firstErrorAgency) {
    return {
      status: status,
      metadata: {
        groupings: groupedAgencies
      }
    }
  }

  return {
    status: status,
    error: {
      message: firstErrorAgency.error.message,
      agency: firstErrorAgency.gtfsId,
    },
    metadata: {
      groupings: groupedAgencies,
    }
  }
}

function INTERNAL__getStatusFromAgenciesRecord(record: NonNullable<INTERNAL__MappedValues>): AppValidationStatusOption {
  if (record.FAILED.length >= 1) {
    return "FAILED"
  }

  if (record.RUNNING.length >= 1) {
    return "RUNNING"
  }

  return "SUCCEEDED"
}

